<?php
/* 14th October 2007. version 0.1
 * By Oli Warner - http://www.thepcspy.com
 * 
 * This is an automated packing script using Nicolas Martin's PHP
 * port of Dean Edwards' packer.
 *
 * See class.JavaScriptPacker.php for more information.
 * 
 * License: http://creativecommons.org/licenses/LGPL/2.1/
 *
 * ==================================================================
 *  Notes
 * ==================================================================
 *
 * For immediate automated packing, make sure you copy the .htaccess
 * file. 
 *
 * For sheduled packing, do not copy the .htaccess file and create a
 * crontab entry to call the script via lynx or wget.
 *
 * Files are packed in their alphabetical order so make sure files
 * are named accordingly. Example: myCode.js is logically dependant on
 * framework.js, so rename framework.js to 1.framework.js
 *
 */
 
$debugMode = $_GET['debug'] == "1";

 // list the files
line("Reading directory", 0);
$files = array();
$handler = opendir('.');
while ($file = readdir($handler))
	if ($file != "packed.js" && $file != "unpacked.js" && strpos($file, '.js',1))
		$files[] = $file;
closedir($handler);
sort($files);

line("Checking freshness", 0);

// files exist?
$regenerate = ! file_exists("packed.js");

// check last modified dates (skip if we know the files need creating)
if (!$regenerate) {
	$lastCreate = filemtime("packed.js");
	line("Last run: $lastCreate", 1);
	
	foreach ($files as $filename) {
		$thisfiletime = filemtime($filename);

		line("$filename last edit: $thisfiletime", 1);

		if ($thisfiletime < $lastCreate)
			continue; // exit immediately so we don't waste cycles
		
		$regenerate = true;
		line("Needs regeneration.",0);
		break;
	}
}

if ($regenerate) {
	$toCompress = "";
	
	foreach ($files as $filename) {
		line("Reading $filename", 1);
		$toCompress .= file_get_contents($filename, true) ."\n\n";
	}
	
	line('Writing to <a href="unpacked.js">unpacked.js</a>', 0);
	$fh = fopen("unpacked.js", 'w');
	fwrite($fh, $toCompress);
	fclose($fh);
	
	line("Done. Result is ~" . round(filesize("unpacked.js")/1024, 0) . "KB.", 0);
	
	line("Loading Packer", 0);
	require("class.JavaScriptPacker.php");
	$myPacker = new JavaScriptPacker($toCompress);
	
	line('Writing to <a href="packed.js">packed.js</a>', 0);
	$buildTime = time();
	$fh = fopen("packed.js", 'w');
	fwrite($fh,"//Packed with AutoPacker - http://thepcspy.com/autopacker\n//Packed at $buildTime\n//See unpacked.js for more details including copyright\n");
	fwrite($fh, $myPacker->pack());
	fclose($fh);
	
	line("Done. Result is ~" . round(filesize("packed.js")/1024, 0) . "KB.", 0);
} 
else
	line("No work done. Packed files are still fresh.", 0);
	
// output file
if (!$debugMode) {
	$fn = "packed.js";
	$fs = filesize($fn);
	
	header('Last-Modified: '.gmdate('D, d M Y H:i:s', filemtime($fn)).' GMT', true, 200);
	header('Content-Length: '.$fs);
	header('Content-Type: application/x-javascript');
	
	echo file_get_contents($fn, true);
}

function line($str, $tabs = 0) {
	global $debugMode;
	
	if (!$debugMode)
		return;
	
	for ($i=0;$i<$tabs*4;$i++)
		echo "&nbsp;";
	
	echo "$str <br />";
}
?>
